#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <dos.h>
#include <conio.h>

typedef unsigned char u8;
typedef signed char s8;

#ifdef __BORLANDC__
typedef unsigned int u16;
typedef signed int s16;
#else
typedef unsigned short u16;
typedef signed short s16;
#endif

typedef unsigned long u32;
typedef signed long s32;

#ifdef __BORLANDC__
u8 far *SCR = (u8 far *)MK_FP(0xB800, 0);	// Borland C-style
#else
u8 *SCR = (u8 *)0xB8000;					// Watcom C-style
#endif

typedef struct RGBA
{
	u8 R, G, B, A;
} RGBA;

static u8 YAMAHA_V6355_bSpecialBit = 0x00;	// The top bit of the Address register $03DD
static u8 YAMAHA_V6355_bHalfBright = 0x00;	// The ACV-1030 requires palettes be reduced to 2 bits, otherwise there is severe desaturation
static u8 bInitialScreenMode = 0;

// The standard CGA palette colours
static const RGBA RGBI_PAL[16] =
{
	{ 0x00, 0x00, 0x00, 0x00 },
	{ 0x00, 0x00, 0xAA, 0x00 },
	{ 0x00, 0xAA, 0x00, 0x00 },
	{ 0x00, 0xAA, 0xAA, 0x00 },
	{ 0xAA, 0x00, 0x00, 0x00 },
	{ 0xAA, 0x00, 0xAA, 0x00 },
	{ 0xAA, 0x55, 0x00, 0x00 },
	{ 0xAA, 0xAA, 0xAA, 0x00 },

	{ 0x55, 0x55, 0x55, 0x00 },
	{ 0x55, 0x55, 0xFF, 0x00 },
	{ 0x55, 0xFF, 0x55, 0x00 },
	{ 0x55, 0xFF, 0x55, 0x00 },
	{ 0xFF, 0x55, 0x55, 0x00 },
	{ 0xFF, 0x55, 0xFF, 0x00 },
	{ 0xFF, 0xFF, 0x55, 0x00 },
	{ 0xFF, 0xFF, 0xFF, 0x00 },
};

void YAMAHA_V6355_SetSpecialMode(u8 bValue)
{
	// The top bit to be written to $03DD (1 = allow 160x200x16 mode)
	YAMAHA_V6355_bSpecialBit = bValue ? 0x80 : 0x00;
}

// Write to the register
void YAMAHA_V6355_SetCurrentRegister(u8 bValue)
{
	// Auto-increments after writing
	outp(0x03DE, bValue);
}

// Select the register
void YAMAHA_V6355_SetAddress(u8 bIndex)
{
	outp(0x03DD, YAMAHA_V6355_bSpecialBit | (bIndex & 0x7F));
}

// Select and write to the register
void YAMAHA_V6355_SetAddressAndRegister(u8 bIndex, u8 bValue)
{
	outp(0x03DD, YAMAHA_V6355_bSpecialBit | (bIndex & 0x7F));
	outp(0x03DE, bValue);
}

// Takes 8-bit R, G, and B values
void YAMAHA_V6355_SetPalette(u8 bIndex, u8 R, u8 G, u8 B)
{
	u16 wPalette = 0;

	// Convert from 8 bits down to 3 bits...
	R >>= 5; G >>= 5; B >>= 5;
	if(YAMAHA_V6355_bHalfBright)
	{
		// The ACV-1030 requires palettes be reduced to 2 bits, otherwise there is severe desaturation
		R >>= 1; G >>= 1; B >>= 1;
	}

	YAMAHA_V6355_SetAddress(0x40 | ((bIndex & 0x0F) << 1));

	wPalette = (R) | (G << 12) | (B << 8);
	YAMAHA_V6355_SetCurrentRegister((u8)wPalette);
	YAMAHA_V6355_SetCurrentRegister((u8)(wPalette >> 8));
}

void YAMAHA_V6355_SetupPalette(void)
{
	u8 x;

	// Set to the initial RGBI values used by CGA, EGA, etc.
	for(x = 0; x < 16; x++)
	{
		YAMAHA_V6355_SetPalette(x, RGBI_PAL[x].R, RGBI_PAL[x].G, RGBI_PAL[x].B);
	}
}

void lower_it(char *stringy)
{
	size_t pos, x;

	pos = strlen(stringy);
	for(x = 0; x < pos; x++)
	{
		stringy[x] = tolower(stringy[x]);
	}
}

u8 HV_GetVideoMode(void)
{
	union REGS R;

	R.h.ah = 0x0F;
#ifdef __BORLANDC__
	int86(0x10, &R, &R);
#else
	int386(0x10, &R, &R);
#endif

	printf("Current Video Mode: 0x%02X\n", R.h.al);
	return R.h.al;
}

u8 HV_SetVideoMode(u8 mode)
{
	union REGS R;

#ifdef __BORLANDC__
	R.x.ax = mode;
	int86(0x10, &R, &R);
#else
	R.w.ax = mode;
	int386(0x10, &R, &R);
#endif

	//printf("Mode: %2X (Ret = %02X)\n", mode, R.h.al);

	// 1 = Success (mode requested == current mode) (not guaranteed to work on all BIOS versions!)
	// 0 = Fail
	if(mode != HV_GetVideoMode())
	{
		return 0;
	}
	return 1;
}

void HV_StoreScreenMode(void)
{
	bInitialScreenMode = HV_GetVideoMode();
}

u8 YAMAHA_V6355_InitScreen(void)
{
	u8 mode;
	u16 x;

	/*
	0x04 = 320x200x4 (palette 0 or palette 1)
	0x05 = 320x200x4 ("palette 2")
	0x06 = 640x200x2
	*/

	mode = 0x04;

	if(!HV_SetVideoMode(mode))
	{
		return 0;
	}

	// Set special mode bit (it's used to set the default palette at the end of this function)
	YAMAHA_V6355_SetSpecialMode(1);

	outp(0x03D8, 0x40 | 0x08 | 0x02);	// 160x200x16 mode (16 Color Mode (0x40), Enable Screen (0x08), Enable Colour (!0x04), Graphics (0x02))
	outp(0x03D9, 0x20 | 0x10 | 0x00);	// Set palette 1 (0x20), intensity (bright) (0x10), black border (0x00)

	// Set up the default RGBI palette, possibly in halfbright mode (or change this to set up another palette)
	YAMAHA_V6355_SetupPalette();

	return 1;
}

void YAMAHA_V6355_ReleaseScreen(void)
{
	YAMAHA_V6355_SetSpecialMode(0);	// Switch back to normal CGA modes

	// Restore the default CGA RGBI palette, possibly in halfbright mode
	YAMAHA_V6355_SetupPalette();

	HV_SetVideoMode(bInitialScreenMode);
}

void DisplayBar(int x, int y, int height, int col)
{
	u8 far *base;

	// 640x200x2 = 80 bytes * 200 = 16,000 bytes
	// CGA interleaving applies... (so divide Y by 2)
	base = SCR + (x >> 2) + ((y >> 1) * 80);

	// Halve the height to simplify the odd/even lines
	height >>= 1;

	while(height)
	{
		// (even line)
		// Clearly, I cannot remember how to use far pointers in the Small Model under Borland C...
		//memset(base, (col | (col << 4)), 0x05);		// 5 bytes wide = 10 (chunky) pixels
		base[0] = base[1] = base[2] = base[3] = base[4] = (col | (col << 4));

		// + 8K (odd line)
		base += 0x2000;
		//memset(base, (col | (col << 4)), 0x05);		// 5 bytes wide = 10 (chunky) pixels
		base[0] = base[1] = base[2] = base[3] = base[4] = (col | (col << 4));

		// - 8K + 80
		base -= 0x2000;
		base += 80;

		height--;
	}
}

void Testcard(void)
{
	u8 far *base, bRemapCol;
	int col, y;

	// 640x200x2 = 80 bytes * 200 = 16,000 bytes
	// CGA interleaving applies...
	gotoxy(1, 24);
	for(col = 0x00; col < 0x10; col++)
	{
		// x * 5, y, height, colour
		DisplayBar(col * 20, 0, 204, col);

		//gotoxy((col * 5) + 2, 11);
		//printf("%03d", col);
		//printf("%02d ", col);
	}
}




u8 parse_params(int argc, char *param[])
{
	char temp_str[500];
	//char dest_str_2[500];
	//char temp_str[HOST_MAXPATH];
	u8 arg_num;

	if(!argc) return 0;

	arg_num = 0;

	while(arg_num < argc)
	{
		if((param[arg_num][0] == '-') || (param[arg_num][0] == '/'))
		{
			strcpy(temp_str, (char *)param[arg_num] + 1);
			lower_it((char *)temp_str);
			if(!(strcmp(temp_str, "?")))
			{
				printf("V6355 16-colour test V0.0 Help\n");
				printf("\nOptions:\n");
				printf("/?     - This help.\n");
				printf("/half  - Use half-bright palette, for the ACV-1030 CGA card\n");
				printf("\n");
				return 0;
			}
			if(!(strcmp(temp_str, "half")))
			{
				YAMAHA_V6355_bHalfBright = 1;
			}
		}
		arg_num++;
	}

	return 1;
}

int main(int argc, char *param[])
{
	u8 bContinue = 1;

	if(argc)
	{
		bContinue = parse_params(argc, param);
	}

	if(bContinue)
	{
		// Do something
		HV_StoreScreenMode();
		//printf("Current screen mode: 0x%02X\n", bInitialScreenMode);

		if(YAMAHA_V6355_InitScreen())
		{
			// Display testcard
			Testcard();

			// Wait for key
			while(!kbhit());
			getch();

			// Back to normal
			YAMAHA_V6355_ReleaseScreen();
		}
	}

	return 1;
}
